function [xi,yi,weigths_on_ref_element,phi,dphix,dphiy]=basis_on_quad2D(fem,degree)
%BASIS_ON_QUAD2D finite element basis functions.
%   [X,Y,W,PHI,DXPHIX,DYPHI]=BASIS_ON_QUAD(FEM,DEGREE) computes the basis functions
%   and their derivatives on X and on Y of the finite element type FEM of the quadrature
%   nodes (X,Y). The quadrature nodes and the weigths W are they of the Dunavant quadrature
%   formula of degree DEGREE (see, DUNAVANT).
%

%       F. Saleri 13-01-03.

[xi,yi,weigths_on_ref_element]=dunavant(degree);   

switch fem
case 'P1'
    phi(1,:) = 1-xi-yi;
    phi(2,:) = xi;
    phi(3,:) = yi;
    dphix(1,:) = -1+0.*xi;
    dphix(2,:) =  1+0.*xi;
    dphix(3,:) =  0+0.*xi;
    dphiy(1,:) = -1+0.*xi;
    dphiy(2,:) =  0+0.*xi;
    dphiy(3,:) =  1+0.*xi;
case 'P2'
    phi(1,:) = (1-xi-yi).*(1-2*xi-2*yi);
    phi(2,:) = xi.*(-1+2*xi);
    phi(3,:) = yi.*(-1+2*yi);
    phi(4,:) = 4*xi.*(1-xi-yi);
    phi(5,:) = 4*xi.*yi;
    phi(6,:) = 4*yi.*(1-xi-yi);
    dphix(1,:) = -3+4*xi+4*yi;
    dphix(2,:) = -1+4*xi;
    dphix(3,:) = 0 + 0.*xi;
    dphix(4,:) = 4-8*xi-4*yi;
    dphix(5,:) = 4*yi;
    dphix(6,:) = -4*yi;
    dphiy(1,:) = -3+4*xi+4*yi;
    dphiy(2,:) = 0+0.*xi;
    dphiy(3,:) = -1+4*yi;
    dphiy(4,:) = -4*xi;
    dphiy(5,:) = 4*xi;
    dphiy(6,:) = 4-4*xi-8*yi;
case 'P3'
    phi(1,:) = (1-xi-yi).*(1-3*xi-3*yi).*(1-3/2*xi-3/2*yi);
    phi(2,:) = 9*xi.*(xi-1/3).*(xi-2/3)/2;
    phi(3,:) = 9*yi.*(yi-1/3).*(yi-2/3)/2;
    phi(4,:) = 9*xi.*(1-3/2*xi-3/2*yi).*(1-xi-yi);
    phi(5,:) = 27*xi.*(xi-1/3).*(1-xi-yi)/2;
    phi(6,:) = 27*xi.*yi.*(xi-1/3)/2;
    phi(7,:) = 27*xi.*yi.*(yi-1/3)/2;
    phi(8,:) = 27*yi.*(yi-1/3).*(1-xi-yi)/2;
    phi(9,:) = 9*yi.*(1-3/2*xi-3/2*yi).*(1-xi-yi);
    phi(10,:) = 27*xi.*yi.*(1-xi-yi);
    dphix(1,:) = -(1-3*xi-3*yi).*(1-3/2*xi-3/2*yi)-3*(1-xi-yi).*(1-3/2*xi-3/2*yi)-3/2*(1-xi-yi).*(1-3*xi-3*yi);
    dphix(2,:) = 9/2*(xi-1/3).*(xi-2/3)+9/2*xi.*(xi-2/3)+9/2*xi.*(xi-1/3); 
    dphix(3,:) = 0+0.*xi; 
    dphix(4,:) = 9*(1-xi-yi).*(1-3/2*xi-3/2*yi)-27/2*xi.*(1-xi-yi)-9*xi.*(1-3/2*xi-3/2*yi);
    dphix(5,:) = 27/2*(xi-1/3).*(1-xi-yi)+27/2*xi.*(1-xi-yi)-27/2*xi.*(xi-1/3); 
    dphix(6,:) = 27/2*yi.*(xi-1/3)+27/2*xi.*yi;
    dphix(7,:) = 27/2*yi.*(yi-1/3);
    dphix(8,:) =-27/2*yi.*(yi-1/3); 
    dphix(9,:) =-27/2*yi.*(1-xi-yi)-9*yi.*(1-3/2*xi-3/2*yi);
    dphix(10,:) =27*yi.*(1-xi-yi)-27*xi.*yi;
    dphiy(1,:) =-(1-3*xi-3*yi).*(1-3/2*xi-3/2*yi)-3*(1-xi-yi).*(1-3/2*xi-3/2*yi)-3/2*(1-xi-yi).*(1-3*xi-3*yi);
    dphiy(2,:) =0+0.*xi;
    dphiy(3,:) =9/2*(yi-1/3).*(yi-2/3)+9/2*yi.*(yi-2/3)+9/2*yi.*(yi-1/3);
    dphiy(4,:) = -27/2*xi.*(1-xi-yi)-9*xi.*(1-3/2*xi-3/2*yi);
    dphiy(5,:) =-27/2*xi.*(xi-1/3);
    dphiy(6,:) =27/2*xi.*(xi-1/3);
    dphiy(7,:) =27/2*xi.*(yi-1/3)+27/2*xi.*yi;
    dphiy(8,:) =27/2*(yi-1/3).*(1-xi-yi)+27/2*yi.*(1-xi-yi)-27/2*yi.*(yi-1/3);
    dphiy(9,:) =9*(1-xi-yi).*(1-3/2*xi-3/2*yi)-27/2*yi.*(1-xi-yi)-9*yi.*(1-3/2*xi-3/2*yi);
    dphiy(10,:) =27*xi.*(1-xi-yi)-27*xi.*yi;
case 'Pt'
    phi(1,:) = (1-xi-yi).*(1-2*xi-2*yi+3*xi.*yi);
    phi(2,:) = xi.*(-1+2*xi+3*yi-3*xi.*yi-3*yi.^2);
    phi(3,:) = yi.*(-1+2*yi+3*xi-3*xi.*yi-3*xi.^2);
    phi(4,:) = 4*xi.*(1-xi-yi).*(1-3*yi);
    phi(5,:) = 4*xi.*yi.*(-2+3*xi+3*yi);
    phi(6,:) = 4*yi.*(1-xi-yi).*(1-3*xi);
    phi(7,:) = 27*xi.*yi.*(1-xi-yi);
    dphix(1,:) = -1+2*xi+2*yi-3*xi.*yi+(1-xi-yi).*(-2+3*yi);
    dphix(2,:) = -1+2*xi+3*yi-3*xi.*yi-3*yi.^2+xi.*(2-3*yi);
    dphix(3,:) = yi.*(3-3*yi-6*xi);
    dphix(4,:) = 4*(1-xi-yi).*(1-3*yi)-4*xi.*(1-3*yi);
    dphix(5,:) = 4*yi.*(-2+3*xi+3*yi)+12*xi.*yi;
    dphix(6,:) = -4*yi.*(1-3*xi)-12*yi.*(1-xi-yi);
    dphix(7,:) = 27*yi.*(1-xi-yi)-27*xi.*yi;
    dphiy(1,:) = -1+2*xi+2*yi-3*xi.*yi+(1-xi-yi).*(-2+3*xi);
    dphiy(2,:) = xi.*(3-3*xi-6*yi);
    dphiy(3,:) = -1+2*yi+3*xi-3*xi.*yi-3*xi.^2+yi.*(2-3*xi);
    dphiy(4,:) = -4*xi.*(1-3*yi)-12*xi.*(1-xi-yi);
    dphiy(5,:) = 4*xi.*(-2+3*xi+3*yi)+12*xi.*yi;
    dphiy(6,:) = 4*(1-xi-yi).*(1-3*xi)-4*yi.*(1-3*xi);
    dphiy(7,:) = 27*xi.*(1-xi-yi)-27*xi.*yi;
case 'B1'
    phi(1,:) = (1-xi-yi).*(1-9*xi.*yi);
    phi(2,:) = xi-9*xi.*yi.*(1-xi-yi);
    phi(3,:) = yi-9*xi.*yi.*(1-xi-yi);
    phi(4,:) = 27*xi.*yi.*(1-xi-yi);
    dphix(1,:) = 18*xi.*yi-1-9*(1-yi).*yi;
    dphix(2,:) = 18*xi.*yi+1-9*(1-yi).*yi;
    dphix(3,:) = 9*yi.*(-1+2*xi+yi);
    dphix(4,:) = -27*yi.*(-1+2*xi+yi);
    dphiy(1,:) = 9*xi.^2+(18*yi-9).*xi-1;
    dphiy(2,:) = 9*xi.*(-1+xi+2*yi);
    dphiy(3,:) = 9*xi.^2+(18*yi-9).*xi+1;
    dphiy(4,:) = -27*xi.*(-1+xi+2*yi); 
case 'Pi'
    iT1 = find(1-2*xi-2*yi >= 0 == 1);
    % First sub-triangle
    phi(1,iT1) = 1-2*xi(iT1)-2*yi(iT1);
    phi(2,iT1) = 0;
    phi(3,iT1) = 0;
    phi(4,iT1) = 2*xi(iT1);
    phi(5,iT1) = 0;
    phi(6,iT1) = 2*yi(iT1);
    dphix(1,iT1) = -2;
    dphix(2,iT1) = 0;
    dphix(3,iT1) = 0;
    dphix(4,iT1) = 2;
    dphix(5,iT1) = 0;
    dphix(6,iT1) = 0;
    dphiy(1,iT1) = -2;
    dphiy(2,iT1) = 0;
    dphiy(3,iT1) = 0;
    dphiy(4,iT1) = 0;
    dphiy(5,iT1) = 0;
    dphiy(6,iT1) = 2;
    % Second sub-triangle
    iT2 = find(xi >= 0.5 == 1);
    phi(1,iT2) = 0;
    phi(2,iT2) = 2*xi(iT2)-1;
    phi(3,iT2) = 0;
    phi(4,iT2) = 2-2*xi(iT2)-2*yi(iT2);
    phi(5,iT2) = 2*yi(iT2);
    phi(6,iT2) = 0;
    dphix(1,iT2) = 0;
    dphix(2,iT2) = 2;
    dphix(3,iT2) = 0;
    dphix(4,iT2) = -2;
    dphix(5,iT2) = 0;
    dphix(6,iT2) = 0;
    dphiy(1,iT2) = 0;
    dphiy(2,iT2) = 0;
    dphiy(3,iT2) = 0;
    dphiy(4,iT2) = -2;
    dphiy(5,iT2) = 2;
    dphiy(6,iT2) = 0;
    % Third sub-triangle
    iT3 = find(yi >= 0.5 == 1);
    phi(1,iT3) = 0;
    phi(2,iT3) = 0;
    phi(3,iT3) = 2*yi(iT3)-1;
    phi(4,iT3) = 0;
    phi(5,iT3) = 2*xi(iT3);
    phi(6,iT3) = 2-2*yi(iT3)-2*xi(iT3);
    dphix(1,iT3) = 0;
    dphix(2,iT3) = 0;
    dphix(3,iT3) = 0;
    dphix(4,iT3) = 0;
    dphix(5,iT3) = 2;
    dphix(6,iT3) = -2;
    dphiy(1,iT3) = 0;
    dphiy(2,iT3) = 0;
    dphiy(3,iT3) = 2;
    dphiy(4,iT3) = 0;
    dphiy(5,iT3) = 0;
    dphiy(6,iT3) = -2;
    % Fourth sub-triangle
    iT4 = find(((1-2*xi-2*yi)<0 & xi<0.5 & yi<0.5) == 1);
    phi(1,iT4) = 0;
    phi(2,iT4) = 0;
    phi(3,iT4) = 0;
    phi(4,iT4) = -2*yi(iT4)+1;
    phi(5,iT4) = -1+2*xi(iT4)+2*yi(iT4);
    phi(6,iT4) = -2*xi(iT4)+1;
    dphix(1,iT4) = 0;
    dphix(2,iT4) = 0;
    dphix(3,iT4) = 0;
    dphix(4,iT4) = 0;
    dphix(5,iT4) = 2;
    dphix(6,iT4) = -2;
    dphiy(1,iT4) = 0;
    dphiy(2,iT4) = 0;
    dphiy(3,iT4) = 0;
    dphiy(4,iT4) = -2;
    dphiy(5,iT4) = 2;
    dphiy(6,iT4) = 0;
case 'Pc'
    % First sub-triangle
    iT1 = find(((xi-yi > 0)&(-xi-2*yi+1 > 0)) == 1);
    phi(1,iT1) = 1-xi(iT1)-2*yi(iT1);
    phi(2,iT1) = xi(iT1)-yi(iT1);
    phi(3,iT1) = 0;
    phi(4,iT1) = 3*yi(iT1);
    dphix(1,iT1) = -1;
    dphix(2,iT1) = 1;
    dphix(3,iT1) = 0;
    dphix(4,iT1) = 0;
    dphiy(1,iT1) = -2;
    dphiy(2,iT1) = -1;
    dphiy(3,iT1) = 0;
    dphiy(4,iT1) = 3;
    % Second sub-triangle
    iT2 = find(((-xi-2*yi+1 <= 0)&(-2*xi-yi+1 <= 0)) == 1);
    phi(1,iT2) = 0;
    phi(2,iT2) = 2*xi(iT2)+yi(iT2)-1;
    phi(3,iT2) = xi(iT2)+2*yi(iT2)-1;
    phi(4,iT2) = 3-3*xi(iT2)-3*yi(iT2);
    dphix(1,iT2) = 0;
    dphix(2,iT2) = 2;
    dphix(3,iT2) = 1;
    dphix(4,iT2) = -3;
    dphiy(1,iT2) = 0;
    dphiy(2,iT2) = 1;
    dphiy(3,iT2) = 2;
    dphiy(4,iT2) = -3;
    % Third sub-triangle
    iT3 = find(((xi-yi <= 0)&(-2*xi-yi+1 > 0)) == 1);
    phi(1,iT3) = 1-2*xi(iT3)-yi(iT3);
    phi(2,iT3) = 0;
    phi(3,iT3) = yi(iT3)-xi(iT3);
    phi(4,iT3) = 3*xi(iT3);
    dphix(1,iT3) = -2;
    dphix(2,iT3) = 0;
    dphix(3,iT3) = -1;
    dphix(4,iT3) = 3;
    dphiy(1,iT3) = -1;
    dphiy(2,iT3) = 0;
    dphiy(3,iT3) = 1;
    dphiy(4,iT3) = 0;
case 'P0'
    phi(1,:) = 1 + 0.*xi;
    dxphi(1,:) = 0 + 0.*xi;
    dyphi(1,:) = 0 + 0.*xi;
otherwise
    msg = messagge(1);
    error(msg)
    phi = []; dphix=[]; dphiy=[];
end

return